' VB Script demonstrating a Sample Logon Script with basic WSH and ADSI functions '
'                                                                                 '
' Version 1.00 - Alain Lissoir                                                    '
' Compaq Computer Corporation - Professional Services - Belgium -                 '
'                                                                                 '
' Any comments or questions:                       EMail:alain.lissoir@compaq.com '

Option Explicit

' -----------------------------------------------------------------------------------------------------------------------
' Internal contants used in the Logon Script
' Logon Script Version --------------------------------------------------------------------------------------------------
Const cLogonScriptVersion = "v1.00"

' Used to map a drive V: if user if member of 'Domain Admins' group. ----------------------------------------------------
' (Drive mapping and user group membership demo)
Const cHomeDirectoryRootShare = "\\MYW2KDC\HOME$"

' -----------------------------------------------------------------------------------------------------------------------
' Popup box buttons, icons and mouse click answer definitions
Const cOKButton                 = 0
Const cOkCancelButton           = 1
Const cAbortRetryIgnoreButton   = 2
Const cYesNoCancelButton        = 3
Const cYesNoButton              = 4
Const cRetryCancelButton        = 5

Const cStopMarkIcon             = 16
Const cQuestionMarkIcon         = 32
Const cExclamationMarkIcon      = 48
Const cInformationMarkIcon      = 64

Const cOKClick                  = 1
Const cCancelClick              = 2
Const cAbortClick               = 3
Const cRetryClick               = 4
Const cIgnoreClick              = 5
Const cYesClick                 = 6
Const cNoClick                  = 7

' -----------------------------------------------------------------------------------------------------------------------
' Window application styles used for Shortcut creation
Const SW_HIDE = 0
Const SW_SHOWNORMAL = 1
Const SW_SHOWMINIMIZED = 2
Const SW_MAXIMIZE = 3
Const SW_SHOWNOACTIVATE = 4
Const SW_MINIMIZE = 6

' -----------------------------------------------------------------------------------------------------------------------
' Public Variables declaration used in the Logon Script
Public WShell
Public WNetwork

Public objFileSystem
Public objLogFileName
Public strLogFileName

Public strStartMenu
Public strDesktop
Public strPrograms
Public strSystemRoot
Public strUserTemp
Public strSystemTemp
Public strSystem32
Public strSystem
Public strAllUsersStartMenu
Public strAllUsersDesktop
Public strAllUsersPrograms

Public strDomainName
Public strDefaultDomainNameADsPath
Public strDefaultDomainNameDN
Public strRootDomainNameADsPath
Public strRootDomainNameDN

Public strUserName
Public strUserNameDN
Public strUserNameADsPath
Public strUserFullName

Public strLocalComputerName
Public strLogonServerName
Public strLogonSiteName

Public strLogonScriptVersion
Public strScriptName
Public strScriptFullName

Public strScriptingName

Public strEngineFullName
Public strEnginePath
Public strEngineVersion

Public strNTVersion
Public strNTBuild
Public strNTServicePack

Public boolVerbose
Public boolErrorPopup

Dim intRC

On Error Resume Next

' -----------------------------------------------------------------------------------------------------------------------
' Create WSH base objects.

' For the Shell operations ----------------------------------------------------------------------------------------------
Set WShell = Wscript.CreateObject("Wscript.Shell")
' For the Network operations --------------------------------------------------------------------------------------------
Set WNetwork = Wscript.CreateObject("Wscript.Network")

' -----------------------------------------------------------------------------------------------------------------------
WShell.LogEvent 0, "Logon Script started."

' -----------------------------------------------------------------------------------------------------------------------
' Will be set to True if command line parameter "Verbose' specified.
' Output is redirected to a file in %TEMP%\%USERNAME%.Log.
boolVerbose = False

' Will be set to True if command line parameter 'ErrorPopup' specified.
' Any error is shown via a Popup window to the user.
' User interaction is mandatory to continue.
boolErrorPopup = False

' -----------------------------------------------------------------------------------------------------------------------
' Get misc. information for script run-time environment.

' Create variable commontly used in the logon script --------------------------------------------------------------------
' Information about misc. directories
strStartMenu = WShell.SpecialFolders("StartMenu") & "\"
strDesktop = WShell.SpecialFolders("Desktop") & "\"
strPrograms = WShell.SpecialFolders("Programs") & "\"
strSystemRoot = ReadEnvironmentVariable (objLogFilename, "Process", "SystemRoot") & "\"
strUserTemp = ReadEnvironmentVariable (objLogFilename, "User", "Temp") & "\"
strSystemTemp = ReadEnvironmentVariable (objLogFilename, "System", "Temp") & "\"
strSystem32 = strSystemRoot & "system32\"
strSystem = strSystemRoot & "system\"
strAllUsersStartMenu = WShell.SpecialFolders("AllUsersStartMenu") & "\"
strAllUsersDesktop = WShell.SpecialFolders("AllUsersDesktop") & "\"
strAllUsersPrograms = WShell.SpecialFolders("AllUsersPrograms") & "\"

' Information about Network ---------------------------------------------------------------------------------------------
strDomainName = WNetwork.UserDomain
strUserName = WNetwork.UserName
strLocalComputerName = WNetwork.ComputerName
strLogonServerName = Mid (ReadEnvironmentVariable (objLogFilename, "Process", "LogonServer"), 3)

' Information about script environment ----------------------------------------------------------------------------------
strScriptName = Wscript.ScriptName
strScriptFullName = Wscript.ScriptFullName
strLogonScriptVersion = cLogonScriptVersion
strScriptingName = Wscript.Name
strEngineFullName = Wscript.FullName
strEnginePath = Wscript.Path
strEngineVersion = Wscript.Version

' Defines a .Log filename -----------------------------------------------------------------------------------------------
strLogFileName = strUserTemp & strUserName & ".log"

' -----------------------------------------------------------------------------------------------------------------------
' Command line argument reading. ('verbose'or nothing)
Dim intIndice
Dim strParameterList()

If (ReadCommandLineArgument (objLogFileName, strParameterList)) Then
   For intIndice = 0 to Ubound(strParameterList) - 1
       Select Case Ucase (strParameterList (intIndice))
           Case "VERBOSE"
                boolVerbose = True
                WShell.LogEvent 0, "'Verbose' mode enabled."
           Case "ERRORPOPUP"
                boolErrorPopup = True
                WShell.LogEvent 0, "'ErrorPopup' mode enabled."
           Case Else
                WShell.LogEvent 1, "Invalid command line parameter detected: '" & _
                                   strParameterList (intIndice) & "'."
       End Select
   Next
End If

If boolVerbose Then
   ' --------------------------------------------------------------------------------------------------------------------
   ' Create the Text file for logging.
   Set objLogFileName = CreateTextFile (strLogFileName)
End If

' -----------------------------------------------------------------------------------------------------------------------
' Put a trace of logon script startup in log file.
intRC = WriteToFile (objLogFileName, "** Logon started " & _
                                      FormatDateTime (Date, vbLongDate) & " at " & _
                                      FormatDateTime (Time, vbShortTime) & ".")

' -----------------------------------------------------------------------------------------------------------------------
' Determine misc. NT version parameters: OS Version, Build number and Service Pack level.
strNTVersion = ReadRegistry (objLogFileName, _
                             "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion", _
                             "CurrentVersion", _
                             "REG_SZ")
strNTBuild = ReadRegistry (objLogFileName, _
                           "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion", _
                           "CurrentBuildNumber", _
                           "REG_SZ")
strNTServicePack = ReadRegistry (objLogFileName, _
                                 "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion", _
                                 "CSDVersion", _
                                 "REG_SZ")

' -----------------------------------------------------------------------------------------------------------------------
' Determine distinquished names and ADsPath needed for further object bindings with ADSI
strRootDomainNameADsPath = GetRootDomainNameADsPath (objLogFileName)
strRootDomainNameDN = GetRootDomainNameDN (objLogFileName)

strDefaultDomainNameADsPath = GetDefaultDomainNameADsPath (objLogFileName)
strDefaultDomainNameDN = GetDefaultDomainNameDN (objLogFileName)

' Bind to the IADsSystemInfo to get current system and user information. ------------------------------------------------
Dim objSysinfo

Set objSysinfo = CreateObject("ADSystemInfo")
If Err.Number Then ErrorHandler objLogFileName, "MAIN - ADSystemInfo", Err, boolErrorPopup

strUserNameDN = objSysinfo.UserName
strUserNameADsPath = "GC://" & strUserNameDN
strLogonSiteName = objSysinfo.SiteName
Wscript.DisconnectObject objSysinfo
Set objSysinfo = Nothing

' -----------------------------------------------------------------------------------------------------------------------
' Get the user FullName stored in AD via ADSI
strUserFullName = GetUserFullName (objLogFileName, strUserNameADsPath)

' -----------------------------------------------------------------------------------------------------------------------
' Save to Log file the Public svariable content (Easier for debugging)
If boolVerbose Then
   LogPublicVariables objLogFileName
End If

' -----------------------------------------------------------------------------------------------------------------------
' Create three new environment variables
intRC = CreateEnvironmentVariable (objLogFileName, "Process", "USERNAMEADsPath", strUserNameADsPath)
intRC = CreateEnvironmentVariable (objLogFileName, "Process", "USERNAMEDN", strUserNameDN)
intRC = CreateEnvironmentVariable (objLogFileName, "Volatile", "SITENAME", strLogonSiteName)

' -----------------------------------------------------------------------------------------------------------------------
' Log environment variables content for System, User, Process and Volatile environment type.
' Warning! 'System' needs special permissions, regular users are denied
If boolVerbose Then
   intRC = GetAllEnvironmentVariables (objLogFileName, "System")
   intRC = GetAllEnvironmentVariables (objLogFileName, "User")
   intRC = GetAllEnvironmentVariables (objLogFileName, "Process")
   intRC = GetAllEnvironmentVariables (objLogFileName, "Volatile")
End If

' -----------------------------------------------------------------------------------------------------------------------
' Enumerates Network Drive connections.
intRC = EnumerateDriveConnections (objLogFileName)

' -----------------------------------------------------------------------------------------------------------------------
' Enumerates Network Printer connections.
intRC = EnumeratePrinterConnections (objLogFileName)

' -----------------------------------------------------------------------------------------------------------------------
' Check current user 'Domain Admins' membership.
If GroupMember (objLogFileName, strUserNameADsPath, "Domain Admins") Then

   ' --------------------------------------------------------------------------------------------------------------------
   ' Current user is a 'Domain Admins' member, makes special mappings for him
   intRC = EnumerateDriveConnections (objLogFileName)
   intRC = ConnectNetworkDrive (objLogFileName, "V:", cHomeDirectoryRootShare)
   intRC = EnumerateDriveConnections (objLogFileName)
   intRC = DisconnectNetworkDrive (objLogFileName, "V:", True)
   intRC = EnumerateDriveConnections (objLogFileName)
End If

' -----------------------------------------------------------------------------------------------------------------------
intRC = EnumeratePrinterConnections (objLogFileName)
intRC = ConnectNetworkPrinter (objLogFileName, "LPT3:", "\\" & strLocalComputerName & "\HPLJ5")
intRC = EnumeratePrinterConnections (objLogFileName)
intRC = DisconnectNetworkPrinter (objLogFileName, "LPT3:", False)
intRC = EnumeratePrinterConnections (objLogFileName)

intRC = ConnectWindowsNetworkPrinter (objLogFileName, "\\" & strLocalComputerName & "\HPLJ5", True)
intRC = EnumeratePrinterConnections (objLogFileName)

' -----------------------------------------------------------------------------------------------------------------------
' Check the number of unread mails. MAPI must be installed and a profile must be configured.
Dim intMailToRead
intMailToRead = CheckMAPIMail (objLogFileName, "", strUserFullName, False)

' Prompt the user with informations -------------------------------------------------------------------------------------
WShell.Popup FormatDateTime (Date, vbLongDate) & " at " & _
             FormatDateTime (Time, vbShortTime) & ", " & _
             "you have " & intMailToRead & " unread mail(s) waiting." & vbCRLF & vbCRLF & _
             "You are logged in site '" & strLogonSiteName & _
             "' by DC '" & strLogonServerName & "'.", _
             0, _
             "(LogonScript) Hello, " & strUserFullName, _
             cInformationMarkIcon Or cOkButton

' -----------------------------------------------------------------------------------------------------------------------
' Create a Shortcut on the Desktop for this particular user.
Dim objShortCut

intRC = WriteToFile (objLogFileName, "** Create a shortcut on the Desktop.")

Set objShortCut = WShell.CreateShortCut(strDesktop & "\Windows Getting Started.Lnk")
objShortCut.Description = "Getting started with Windows NT Server"
objShortCut.Arguments = ""
objShortCut.HotKey = "ALT+CTRL+S"
objShortCut.IconLocation = strSystem32 & "\wizmgr.exe"
objShortCut.TargetPath = strSystem32 & "\wizmgr.exe"
objShortCut.WindowStyle = SW_SHOWNORMAL
objShortCut.WorkingDirectory = strSystem32
objShortCut.Save
If Err.Number Then ErrorHandler objLogFileName, "MAIN - CreateShortCut", Err, boolErrorPopup

' -----------------------------------------------------------------------------------------------------------------------
' Write the registry (Be sure that user has right to create it)
' Creating some "dummy" registry keys to show how to do.
intRC = WriteRegistry (objLogFileName, "HKCU\Software\Compaq\Registry Access", _
                                       "ValueRegBinary", "REG_BINARY", 65534)
intRC = WriteRegistry (objLogFileName, "HKCU\Software\Compaq\Registry Access", _
                                       "ValueRegDWord", "REG_DWORD", 3270523)
intRC = WriteRegistry (objLogFileName, "HKCU\Software\Compaq\Registry Access", _
                                       "ValueRegExpandSz", "REG_EXPAND_SZ", "This is a string")
intRC = WriteRegistry (objLogFileName, "HKCU\Software\Compaq\Registry Access", _
                                       "ValueRegSz", "REG_SZ", "This is another string")

' -----------------------------------------------------------------------------------------------------------------------
' Read the registry (Be sure that user has right to create it)
' Read the just created "dummy" registry keys to show how to do.
' Value is assigned to a variant type variable.
Dim varRegValue

varRegValue = ReadRegistry (objLogFileName, "HKCU\Software\Compaq\Registry Access", _
                                            "ValueRegBinary", "REG_BINARY")
varRegValue = ReadRegistry (objLogFileName, "HKCU\Software\Compaq\Registry Access", _
                                            "ValueRegDWord", "REG_DWORD")
varRegValue = ReadRegistry (objLogFileName, "HKCU\Software\Compaq\Registry Access", _
                                            "ValueRegExpandSz", "REG_EXPAND_SZ")
varRegValue = ReadRegistry (objLogFileName, "HKCU\Software\Compaq\Registry Access", _
                                            "ValueRegSz", "REG_SZ")

' -----------------------------------------------------------------------------------------------------------------------
' Delete the registry (Be sure that user has right to create it)
' Delete the just created "dummy" registry keys to show how to do.
intRC = DeleteRegistry (objLogFileName, "HKCU\Software\Compaq\Registry Access", _
                                        "ValueRegBinary")
intRC = DeleteRegistry (objLogFileName, "HKCU\Software\Compaq\Registry Access", _
                                        "ValueRegDWord")
intRC = DeleteRegistry (objLogFileName, "HKCU\Software\Compaq\Registry Access", _
                                        "ValueRegExpandSz")
intRC = DeleteRegistry (objLogFileName, "HKCU\Software\Compaq\Registry Access", _
                                        "ValueRegSz")
intRC = DeleteRegistry (objLogFileName, "HKCU\Software\Compaq\Registry Access", _
                                        "")
intRC = DeleteRegistry (objLogFileName, "HKCU\Software\Compaq", _
                                        "")

' -----------------------------------------------------------------------------------------------------------------------
' Put a trace of logon script startup in log file.
intRC = WriteToFile (objLogFileName, "** Logon ended " & _
                                      FormatDateTime (Date, vbLongDate) & " at " & _
                                      FormatDateTime (Time, vbShortTime) & ".")

' -----------------------------------------------------------------------------------------------------------------------
intRC = WriteToFile (objLogFileName, "** Closing Log file.")
CloseTextFile (objLogFileName)

' -----------------------------------------------------------------------------------------------------------------------
WShell.LogEvent 0, "Logon Script Ended."

' -----------------------------------------------------------------------------------------------------------------------
' Destroy WSH base objects

Wscript.DisconnectObject (WNetwork)
Set WNetwork = Nothing

Wscript.DisconnectObject (WShell)
Set WShell = Nothing

Wscript.Quit (0)

' End of the Logon Script
' -----------------------------------------------------------------------------------------------------------------------

' -----------------------------------------------------------------------------------------------------------------------
' Next part is the list of available functions used through the Logon Script
' -----------------------------------------------------------------------------------------------------------------------
Private Function ReadRegistry (objFileName, strKeyName, KeyValueName, strRegType)

Dim strRegKey
Dim varRegKeyValue

Dim strTempValue
Dim strChar
Dim strTemp

        On Error Resume Next

        strRegKey = strKeyName & "\" & KeyValueName
        intRC = WriteToFile (objFileName, "** Reading registry '" & strRegKey & _
                                          "'(" & strRegType & ").")

        strTempValue = WShell.RegRead (strRegKey)
        If Err.Number Then
           intRC = ErrorHandler (objFileName, "ReadRegistry", Err, boolErrorPopup)
           Exit Function
        End If

        Select Case strRegType
               Case "REG_BINARY"
                    For Each strChar In strTempValue
                        strTemp = Right("00" & hex(strChar), 2) & strTemp
                    Next
                    varRegKeyValue = "0x" & strTemp
               Case "REG_DWORD"
                    varRegKeyValue = "0x" & Hex (strTempValue)
               Case Else
                    varRegKeyValue = strTempValue
        End Select

        intRC = WriteToFile (objFileName, _
                             strRegKey & "(" & UCase(strRegType) & ") -> " & varRegKeyValue)

        ReadRegistry = varRegKeyValue

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function WriteRegistry (objFileName, strKeyName, KeyValueName, strRegType, varRegKeyValue)

Dim strRegKey

        On Error Resume Next

        strRegKey = strKeyName & "\" & KeyValueName
        Select Case strRegType
               Case "REG_BINARY"
               Case "REG_DWORD"
                    intRC = WriteToFile (objFileName, "** Writing registry '" & _
                                         strRegKey & "(" & UCase(strRegType) & ") -> 0x" & _
                                         Hex(varRegKeyValue))
               Case Else
                    intRC = WriteToFile (objFileName, "** Writing registry '" & _
                                         strRegKey & "(" & UCase(strRegType) & ") -> " & _
                                         varRegKeyValue)
        End Select

        WShell.RegWrite strRegKey, varRegKeyValue, strRegType
        If Err.Number Then
           WriteRegistry = ErrorHandler (objFileName, "WriteRegistry", Err, boolErrorPopup)
           Exit Function
        End If

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function DeleteRegistry (objFileName, strKeyName, KeyValueName)

Dim strRegKey

        On Error Resume Next

        strRegKey = strKeyName & "\" & KeyValueName
        intRC = WriteToFile (objFileName, "** Delete registry '" & strRegKey & "'.")

        WShell.RegDelete strRegKey
        If Err.Number Then
           DeleteRegistry = ErrorHandler (objFileName, "DeleteRegistry", Err, boolErrorPopup)
           Exit Function
        End If

        intRC = WriteToFile (objFileName, strRegKey & " -> DELETED")

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function GetUserFullName (objFileName, strUserNameADsPath)

Dim objUser
Dim strUserFullName

        On Error Resume Next

        intRC = WriteToFile (objFileName, "** Get '" & strUserName & "' user fullname.")

        Set objUser = GetObject(strUserNameADsPath)
        If Err.Number Then
           intRC = ErrorHandler (objFileName, "GetUserFullName", Err, boolErrorPopup)
           Exit Function
        End If

        strUserFullName = objUser.Get("Name")
        If Err.Number Then
           intRC = ErrorHandler (objFileName, "GetUserFullName", Err, boolErrorPopup)
           Exit Function
        End If

        intRC = WriteToFile (objFileName, "Fullname is '" & strUserFullName & "'.")
        GetUserFullName = strUserFullName
        Set objUser = Nothing

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function EnumerateDriveConnections (objFileName)

Dim enumDrives
Dim intIndice

        On Error Resume Next

        intRC = WriteToFile (objFileName, "** Enumerates Network Drive connections.")

        Set enumDrives = WNetwork.EnumNetworkDrives
        If Err.Number Then
           EnumerateDriveConnections = ErrorHandler (objFileName, "EnumerateDriveConnections", _
                                                     Err, boolErrorPopup)
           Exit Function
        End If

        If enumDrives.Count = 0 Then
           intRC = WriteToFile (objFileName, "No drive to list.")
        Else
           intRC = WriteToFile (objFileName, "Current network drive connections:")
           For intIndice = 0 To enumDrives.Count - 1 Step 2
               intRC = WriteToFile (objFileName, enumDrives (intIndice) & " -> " & _
                                                 enumDrives (intIndice + 1))
           Next
        End If

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function ConnectNetworkDrive (objFileName, strDriveLetter, strShareName)

        On Error Resume Next

        intRC = WriteToFile (objFileName, "** Connect to Network Drive '" & _
                                          UCase (strDriveLetter) & " -> " & _
                                          UCase (strShareName) & "'")

        WNetwork.MapNetworkDrive strDriveLetter, strShareName
        If Err.Number Then
           ConnectNetworkDrive = ErrorHandler (objFileName, "ConnectNetworkDrive", _
                                               Err, boolErrorPopup)
           Exit Function
        End If

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function DisconnectNetworkDrive (objFileName, strDriveLetter, boolConfirm)

Dim intClick

        On Error Resume Next

        If boolConfirm Then
           intClick = WShell.Popup ("Remove Network Drive connection '" & _
                                    UCase (strDriveLetter) & "' (Y/N) ?", _
                                    0, _
                                    "(LogonScript) Confirmation", _
                                    cQuestionMarkIcon + cYesNoButton)
           If intClick = cNoClick Then
              Exit Function
           End If
        End If

        intRC = WriteToFile (objFileName, "** Disconnect from Network Drive '" & _
                                          UCase (strDriveLetter) & "'")

        WNetwork.RemoveNetworkDrive strDriveLetter
        If Err.Number Then
           DisconnectNetworkDrive = ErrorHandler (objFileName, "DisconnectNetworkDrive", _
                                                  Err, boolErrorPopup)
           Exit Function
        End If

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function EnumeratePrinterConnections (objFileName)

Dim enumPrinters
Dim intIndice

        On Error Resume Next

        intRC = WriteToFile (objFileName, "** Enumerates Network Printer connections.")

        Set enumPrinters = WNetwork.EnumPrinterConnections
        If Err.Number Then
           EnumeratePrinterConnections = ErrorHandler (objFileName, _
                                                       "EnumeratePrinterConnections", _
                                                       Err, boolErrorPopup)
           Exit Function
        End If

        If enumPrinters.Count = 0 Then
           intRC = WriteToFile (objFileName, "No printer to list.")
        Else
           intRC = WriteToFile (objFileName, "Current network printer connections:")
           For intIndice = 0 To enumPrinters.Count - 1 Step 2
               intRC = WriteToFile (objFileName, enumPrinters (intIndice) & " -> " & _
                                                 enumPrinters (intIndice + 1))
           Next
        End If

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function ConnectWindowsNetworkPrinter (objFileName, strShareName, boolDefault)

        On Error Resume Next

        intRC = WriteToFile (objFileName, "** Connect to Windows Printer '" & _
                                          Ucase (strShareName) & "'")

        WNetwork.AddWindowsPrinterConnection strShareName
        If Err.Number Then
           ConnectWindowsNetworkPrinter = ErrorHandler (objFileName, _
                                                        "ConnectWindowsNetworkPrinter", _
                                                        Err, boolErrorPopup)
           Exit Function
        End If

        If boolDefault Then
           intRC = WriteToFile (objFileName, "** Make '" & UCase (strShareName) & _
                                             "' as default Printer.")
           WNetwork.SetDefaultPrinter strShareName
           If Err.Number Then
              ConnectWindowsNetworkPrinter = ErrorHandler (objFileName, _
                                                           "ConnectWindowsNetworkPrinter", _
                                                           Err, boolErrorPopup)
              Exit Function
           End If

        End If

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function ConnectNetworkPrinter (objFileName, strLPT, strShareName)

        On Error Resume Next

        intRC = WriteToFile (objFileName, "** Connect to Network Printer '" & _
                                          UCase (strLPT) & " -> " & _
                                          UCase (strShareName) & "'")

        WNetwork.AddPrinterConnection strLPT, strShareName
        If Err.Number Then
           ConnectNetworkPrinter = ErrorHandler (objFileName, "ConnectNetworkPrinter", _
                                   Err, boolErrorPopup)
           Exit Function
        End If

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function DisconnectNetworkPrinter (objFileName, strLPT, boolConfirm)

Dim intClick

        On Error Resume Next

        If boolConfirm Then
           intClick = WShell.Popup ("Remove Network Printer connection '" & _
                                    UCase (strLPT) & "' (Y/N) ?", _
                                    0, _
                                    "(LogonScript) Confirmation", _
                                    cQuestionMarkIcon + cYesNoButton)
           If intClick = cNoClick Then
              Exit Function
           End If
        End If

        intRC = WriteToFile (objFileName, "** Disconnect from Network Printer '" & _
                                          UCase (strLPT) & "'")

        WNetwork.RemovePrinterConnection strLPT
        If Err.Number Then
           DisconnectNetworkPrinter = ErrorHandler (objFileName, "DisconnectNetworkPrinter", _
                                      Err, boolErrorPopup)
           Exit Function
        End If

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function ReadEnvironmentVariable (objFileName, strEnvironmentType, strVarName)

Dim objEnvironment

        On Error Resume Next

        intRC = WriteToFile (objFileName, "** Reading '" & strVarName & _
                                             "' in '" & strEnvironmentType & _
                                             "' environment.")

        ' Create a new variable via environment object.
        Set objEnvironment = WShell.Environment (strEnvironmentType)
        If Err.Number Then
           intRC = ErrorHandler (objFileName, "ReadEnvironmentVariable", Err, boolErrorPopup)
           Exit Function
        End If

        ReadEnvironmentVariable = WShell.ExpandEnvironmentStrings (objEnvironment(strVarName))
        If Err.Number Then
           intRC = ErrorHandler (objFileName, "ReadEnvironmentVariable", Err, boolErrorPopup)
           Exit Function
        End If

        Set objEnvironment = Nothing

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function CreateEnvironmentVariable (objFileName, strEnvironmentType, strVarName, varValue)

Dim objEnvironment

        On Error Resume Next

        intRC = WriteToFile (objFileName, "** Creating '" & strVarName & _
                                             "=" & varValue & _
                                             "' in '" & strEnvironmentType & _
                                             "' environment.")

        ' Create a new variable via environment object.
        Set objEnvironment = WShell.Environment (strEnvironmentType)
        If Err.Number Then
           CreateEnvironmentVariable = ErrorHandler (objFileName, "CreateEnvironmentVariable", _
                                                     Err, boolErrorPopup)
           Exit Function
        End If

        objEnvironment (strVarName)=varValue
        If Err.Number Then
           CreateEnvironmentVariable = ErrorHandler (objFileName, "CreateEnvironmentVariable", _
                                                     Err, boolErrorPopup)
           Exit Function
        End If

        Set objEnvironment = Nothing

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function RemoveEnvironmentVariable (objFileName, strEnvironmentType, strVarName)

Dim objEnvironment

        On Error Resume Next

        intRC = WriteToFile (objFileName, "** Removing '" & strVarName & _
                                             "' in '" & strEnvironmentType & _
                                             "' environment.")

        ' Remove variable via environment object.
        Set objEnvironment = WShell.Environment (strEnvironmentType)
        If Err.Number Then
           RemoveEnvironmentVariable  = ErrorHandler (objFileName, "RemoveEnvironmentVariable", _
                                                      Err, boolErrorPopup)
           Exit Function
        End If


        objEnvironment.Remove (strVarName)

        Set objEnvironment = Nothing

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function GetAllEnvironmentVariables (objFileName, strEnvironmentType)

Dim strVarName
Dim objEnvironment

        On Error Resume Next

        ' List all environment variables in the given environment
        intRC = WriteToFile (objFileName, "** Getting '" & strEnvironmentType & "' variables.")

        Set objEnvironment = WShell.Environment (strEnvironmentType)
        If Err.Number Then
           GetAllEnvironmentVariables = ErrorHandler (objFileName, "GetAllEnvironmentVariables", _
                                                      Err, boolErrorPopup)
           Exit Function
        End If

        For Each strVarName In objEnvironment
            intRC = WriteToFile (objFileName, strVarName)
        Next

        Set objEnvironment = Nothing

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function ReadCommandLineArgument (objFileName, strParameterList)

Dim objArguments
Dim intIndice

        On Error Resume Next

        intRC = WriteToFile (objFileName, "** Command Line arguments reading.")

        Set objArguments = Wscript.Arguments

        If objArguments.Count = 0 Then
           intRC = WriteToFile (objFileName, "No command line arguments given")
        Else
           ReDim strParameterList (objArguments.Count)
           For intIndice = 0 To objArguments.Count - 1
               intRC = WriteToFile (objFileName, "Argument " & intIndice & "='" & _
                                                 objArguments (intIndice)) & "'"
               strParameterList (intIndice) = objArguments (intIndice)
           Next
        End If

        ReadCommandLineArgument = objArguments.Count

        Set objArguments = Nothing

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function GroupMember (objFileName, strUserNameADsPath, strGroupName)

Dim objUser
Dim objGroup

        On Error Resume Next

        intRC = WriteToFile (objFileName, "** Check '" & strUserName & _
                                             "' user '" & strGroupName & _
                                             "' membership.")

        Set objUser = GetObject(strUserNameADsPath)
        If Err.Number Then
           intRC = ErrorHandler (objFileName, "GroupMember", Err, boolErrorPopup)
           Exit Function
        End If

        For Each objGroup In objUser.Groups
            If strGroupName = objGroup.Get("Name") Then
               intRC = WriteToFile (objFileName, "Member of '" & objGroup.Get("Name") & "'.")
               GroupMember = True
               Exit Function
            End If
        Next

        intRC = WriteToFile (objFileName, "Membership not found.")
        GroupMember = False

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function GetRootDomainNameADsPath (objFileName)

Dim objRoot
Dim strRootDomainContext
Dim objRootDomainContext

        On Error Resume Next

        intRC = WriteToFile (objFileName, "** Getting Root Domain Context ADsPath.")

        Set objRoot = GetObject("LDAP://RootDSE")
        strRootDomainContext = objRoot.Get("RootDomainNamingContext")
        Set objRootDomainContext = GetObject("LDAP://" & strRootDomainContext)
        If Err.Number Then
           intRC = ErrorHandler (objFileName, "GetRootDomainNameADsPath", Err, boolErrorPopup)
           Exit Function
        End If

        intRC = WriteToFile (objFileName, objRootDomainContext.ADsPath)

        GetRootDomainNameADsPath = objRootDomainContext.ADsPath

        Set objRootDomainContext = Nothing
        Set objRoot = Nothing

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function GetRootDomainNameDN (objFileName)

Dim objRoot
Dim strRootDomainContext
Dim objRootDomainContext

        On Error Resume Next

        intRC = WriteToFile (objFileName, "** Getting Root Domain Context distinguishedName.")

        Set objRoot = GetObject("LDAP://RootDSE")
        strRootDomainContext = objRoot.Get("RootDomainNamingContext")
        Set objRootDomainContext = GetObject("LDAP://" & strRootDomainContext)
        If Err.Number Then
           intRC = ErrorHandler (objFileName, "GetRootDomainNameDN", Err, boolErrorPopup)
           Exit Function
        End If

        intRC = WriteToFile (objFileName, objRootDomainContext.distinguishedName)

        GetRootDomainNameDN = objRootDomainContext.distinguishedName

        Set objRootDomainContext = Nothing
        Set objRoot = Nothing

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function GetDefaultDomainNameADsPath (objFileName)

Dim objRoot
Dim strDefaultDomainContext
Dim objDefaultDomainContext

        On Error Resume Next

        intRC = WriteToFile (objFileName, "** Getting Default Domain Context ADsPath.")

        Set objRoot = GetObject("LDAP://RootDSE")
        strDefaultDomainContext = objRoot.Get("DefaultNamingContext")
        Set objDefaultDomainContext = GetObject("LDAP://" & strDefaultDomainContext)
        If Err.Number Then
           intRC = ErrorHandler (objFileName, "GetDefaultDomainNameADsPath", Err, boolErrorPopup)
           Exit Function
        End If

        intRC = WriteToFile (objFileName, objDefaultDomainContext.ADsPath)

        GetDefaultDomainNameADsPath = objDefaultDomainContext.ADsPath

        Set objDefaultDomainContext = Nothing
        Set objRoot = Nothing

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function GetDefaultDomainNameDN (objFileName)

Dim objRoot
Dim strDefaultDomainContext
Dim objDefaultDomainContext

        On Error Resume Next

        intRC = WriteToFile (objFileName, _
                             "** Getting Default Domain Context distinguishedName.")

        Set objRoot = GetObject("LDAP://RootDSE")
        strDefaultDomainContext = objRoot.Get("DefaultNamingContext")
        Set objDefaultDomainContext = GetObject("LDAP://" & strDefaultDomainContext)
        If Err.Number Then
           intRC = ErrorHandler (objFileName, "GetDefaultDomainNameDN", Err, boolErrorPopup)
           Exit Function
        End If

        intRC = WriteToFile (objFileName, objDefaultDomainContext.distinguishedName)

        GetDefaultDomainNameDN = objDefaultDomainContext.distinguishedName

        Set objDefaultDomainContext = Nothing
        Set objRoot = Nothing

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function CheckMAPIMail (objFileName, strMAPIProfileName, strUserName, boolPrompt)

Dim MAPISession
Dim MAPIMessages

        On Error Resume Next

        ' No MAPI profile name is given, use the default name instead.
        If strMAPIProfileName = "" Then
           strMAPIProfileName = "MS Exchange Settings"
        End If

        intRC = WriteToFile (objFileName, "** MAPI Logon with MAPI profile '" & _
                                          strMAPIProfileName & "' for user '" & _
                                          strUserName & "'.")

        Set MAPISession = Wscript.CreateObject ("MSMAPI.MAPISession")
        Set MAPIMessages = Wscript.CreateObject ("MSMAPI.MAPIMessages")
        ' If MAPI not installed, object creation will generate an error.
        ' (i.e. Outlook was installed.)
        If Err.Number Then
           intRC = ErrorHandler (objFileName, "CheckMAPIMail", Err, boolErrorPopup)
           Exit Function
        End If

        MAPISession.DownLoadMail = False

        ' Do not prompt the user for the MAPI profile, use the default
        MAPISession.LogonUI = False
        MAPISession.UserName = strMAPIProfileName

        ' Signon method.
        MAPISession.SignOn
        If Err.Number Then
           intRC = ErrorHandler (objFileName, "CheckMAPIMail", Err, boolErrorPopup)
           Exit Function
        End If

        MAPISession.NewSession = True

        ' Associate the MAPIMessages session to current opened MAPI session
        MAPIMessages.SessionID = MAPISession.SessionID

        MAPIMessages.FetchUnreadOnly = True
        MAPIMessages.Fetch

        ' Test the 'MAPIMessages.MsgCount' and skip prompting if equal to zero
        ' If counter is equal to zero, its needless to show this information.
        CheckMAPIMail = MAPIMessages.MsgCount
        intRC = WriteToFile (objFileName, "Number of messages unread=" & _
                                          MAPIMessages.MsgCount & ".")
        If MAPIMessages.MsgCount And boolPrompt Then
           WShell.Popup "Today, you have " & MAPIMessages.MsgCount & " unread mail(s).", _
                          0, _
                          "(LogonScript) Hello, " & strUserName, _
                          cInformationMarkIcon Or cOkButton
        End If

        ' Close the session.
        MAPISession.SignOff

        ' Flag for new session.
        MAPISession.NewSession = False

        Wscript.DisconnectObject (MAPIMessages)
        Set MAPIMessages = Nothing

        Wscript.DisconnectObject (MAPISession)
        Set MAPISession = Nothing

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function LogPublicVariables (objFileName)

        intRC = WriteToFile (objFileName, _
                             "** Available Public variable for next script operations.")

        intRC = WriteToFile (objFileName, "strStartMenu=" & strStartMenu)
        intRC = WriteToFile (objFileName, "strDesktop=" & strDesktop)
        intRC = WriteToFile (objFileName, "strPrograms=" & strPrograms)
        intRC = WriteToFile (objFileName, "strSystemRoot=" & strSystemRoot)
        intRC = WriteToFile (objFileName, "strUserTemp=" & strUserTemp)
        intRC = WriteToFile (objFileName, "strSystemTemp=" & strSystemTemp)
        intRC = WriteToFile (objFileName, "strSystem32=" & strSystem32)
        intRC = WriteToFile (objFileName, "strSystem=" & strSystem)
        intRC = WriteToFile (objFileName, "strAllUsersStartMenu=" & strAllUsersStartMenu)
        intRC = WriteToFile (objFileName, "strAllUsersDesktop=" & strAllUsersDesktop)
        intRC = WriteToFile (objFileName, "strAllUsersPrograms=" & strAllUsersPrograms)

        intRC = WriteToFile (objFileName, "strDomainName=" & strDomainName)
        intRC = WriteToFile (objFileName, "strDefaultDomainNameADsPath=" & _
                                           strDefaultDomainNameADsPath)
        intRC = WriteToFile (objFileName, "strDefaultDomainNameDN=" & strDefaultDomainNameDN)
        intRC = WriteToFile (objFileName, "strRootDomainNameADsPath=" & strRootDomainNameADsPath)
        intRC = WriteToFile (objFileName, "strRootDomainNameDN=" & strRootDomainNameDN)

        intRC = WriteToFile (objFileName, "strUserName=" & strUserName)
        intRC = WriteToFile (objFileName, "strUserFullName=" & strUserFullName)
        intRC = WriteToFile (objFileName, "strUserNameADsPath=" & strUserNameADsPath)
        intRC = WriteToFile (objFileName, "strUserNameDN=" & strUserNameDN)

        intRC = WriteToFile (objFileName, "strLocalComputerName=" & strLocalComputerName)
        intRC = WriteToFile (objFileName, "strLogonServerName=" & strLogonServerName)
        intRC = WriteToFile (objFileName, "strLogonSiteName=" & strLogonSiteName)

        intRC = WriteToFile (objFileName, "strLogonScriptVersion=" & strLogonScriptVersion)
        intRC = WriteToFile (objFileName, "strScriptName=" & strScriptName)
        intRC = WriteToFile (objFileName, "strScriptFullName=" & strScriptFullName)
        intRC = WriteToFile (objFileName, "strScriptingName=" & strScriptingName)
        intRC = WriteToFile (objFileName, "strEngineFullName=" & strEngineFullName)
        intRC = WriteToFile (objFileName, "strEnginePath=" & strEnginePath)
        intRC = WriteToFile (objFileName, "strEngineVersion=" & strEngineVersion)
        intRC = WriteToFile (objFileName, "strLogFileName=" & strLogFileName)

        intRC = WriteToFile (objFileName, "strNTVersion=" & strNTVersion)
        intRC = WriteToFile (objFileName, "strNTBuild=" & strNTBuild)
        intRC = WriteToFile (objFileName, "strNTServicePack=" & strNTServicePack)

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function ErrorHandler (objFileName, strFunctionName, Err, boolPopupErrors)

        intRC = WriteToFile (objFileName, "** ERROR("& strFunctionName &"):0x" & _
                                          Hex (Err.Number) & vbCRLF & "   " & _
                                          Err.Description)

        ' Put the error in the event log.
        WShell.LogEvent 1, "ERROR("& strFunctionName &"):0x" & _
                           Hex (Err.Number) & vbCRLF & _
                           Err.Description

        ' Popup the error message to the user if set to True.
        If boolPopupErrors Then
           WShell.Popup "ERROR("& strFunctionName &"):0x" & Hex (Err.Number) & vbCRLF & _
                        Err.Description, _
                        0, _
                        "(LogonScript) ERROR!", _
                        cStopMarkIcon Or cOkButton
        End If

        ErrorHandler = True

        Err.Clear

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function CreateTextFile (strFileName)

Dim objFileName

        On Error Resume Next

        Set objFileSystem = Wscript.CreateObject ("Scripting.FileSystemObject")
        If Err.Number Then
           CreateTextFile = ErrorHandler ("", "CreateTextFile", Err, True)
           Exit Function
        End If

        Set objFileName = objFileSystem.CreateTextFile (strFileName, True)
        If Err.Number Then
           CreateTextFile = ErrorHandler ("", "CreateTextFile", Err, True)
           Exit Function
        End If

        Set CreateTextFile = objFileName

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function CloseTextFile (objFileName)

        If boolVerbose Then
           objFileName.Close

           Set objFileName = Nothing

           Wscript.DisconnectObject objFileSystem
           Set objFileSystem = Nothing
        End If

End Function

' -----------------------------------------------------------------------------------------------------------------------
Private Function WriteToFile (objFileName, Text)

        If boolVerbose Then
           If Mid(Text, 1, 3) = "** " Then
              objFileName.WriteLine (Text)
           Else
              objFileName.WriteLine "   " & Text
           End If
        End If

End Function